<?php
// Start the session to access the logged-in user's ID
session_start();

// =================== DATABASE CONNECTION ===================
$host = "localhost";
$user = "thevkin_schlautdb";
$pass = "VK_AutSchlDb";
$db = "thevkin_schlautdb";
 
$conn = mysqli_connect($host, $user, $pass, $db);
if (!$conn) { die("DB Connection Failed"); }

// =================== AUTO-ID GENERATOR (Kept as is) ===================
function generateID($conn, $type) {
    if ($type == "client_head") {
        $prefix = "#VKCL";
        $table = "client_head";
    } else {
        $prefix = "#VKPRNC";
        $table = "principals";
    }

    $q = mysqli_query($conn, "SELECT id FROM $table ORDER BY created_at DESC LIMIT 1");

    if (mysqli_num_rows($q) == 0) {
        return $prefix . "01";
    }

    $row = mysqli_fetch_assoc($q);
    $lastID = intval(substr($row['id'], -2));
    $newID = str_pad($lastID + 1, 2, "0", STR_PAD_LEFT);

    return $prefix . $newID;
}

// =================== FORM SUBMIT ===================
$message = "";
$message_class = "";

if (isset($_POST['submit'])) {

    // 1. **CRITICAL STEP:** Get the ID of the logged-in user (Super Admin)
    // We assume the ID is stored in a session variable after login.
    // If the user isn't logged in, they shouldn't be able to access this page.
    $created_by_id = $_SESSION['superadmin_id'] ?? null; 
    
    if (!$created_by_id) {
        $message = "❌ Error: Super Admin ID is missing. Please log in again.";
        $message_class = "error";
        // Halt further execution
    } else {
        
        $type        = $_POST['type'];
        $first       = $_POST['first_name'];
        $last        = $_POST['last_name'];
        $email       = $_POST['email'];
        $username    = $_POST['username'];
        $password    = $_POST['password']; 
        $phone       = $_POST['phone'];
        $partnered   = $_POST['partnered_on'];

        // -------- Generate Unique ID --------
        $genID = generateID($conn, $type);

        // -------- PHOTO UPLOAD --------
        $photoName = null;

        if (!empty($_FILES['photo']['name'])) {
            $photoName = time() . "_" . $_FILES['photo']['name'];
            $path = "uploads/" . $photoName;
            if (!is_dir('uploads')) {
                mkdir('uploads', 0777, true);
            }
            move_uploaded_file($_FILES['photo']['tmp_name'], $path);
        }

        // --- Prepare data for insertion (Security: Added basic escaping) ---
        $first = mysqli_real_escape_string($conn, $first);
        $last = mysqli_real_escape_string($conn, $last);
        $email = mysqli_real_escape_string($conn, $email);
        $username = mysqli_real_escape_string($conn, $username);
        $password = mysqli_real_escape_string($conn, $password);
        $phone = mysqli_real_escape_string($conn, $phone);


        // 2. **INSERT updated:** Added 'created_by' field and its value.
        if ($type == "client_head") {

            $sql = "INSERT INTO client_head 
            (id, first_name, last_name, email, username, password, phone, photo, partnered_on, created_by)
            VALUES ('$genID','$first','$last','$email','$username','$password','$phone','$photoName','$partnered', $created_by_id)";

        } else {

            $sql = "INSERT INTO principals 
            (id, first_name, last_name, email, username, password, phone, photo, partnered_on, created_by)
            VALUES ('$genID','$first','$last','$email','$username','$password','$phone','$photoName','$partnered', $created_by_id)";
        }

        if (mysqli_query($conn, $sql)) {
            $message = "User Created Successfully! Your ID: $genID";
            $message_class = "success";
        } else {
            $message = "❌ Error: " . mysqli_error($conn);
            $message_class = "error";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Add Client Head / Principal | User Management</title>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
<style>
/* --- (CSS remains the same for the best UI look) --- */
* {
    box-sizing: border-box;
    margin: 0;
    padding: 0;
}

body {
    font-family: 'Inter', sans-serif;
    background: #f4f7fa;
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 100vh;
    padding: 20px;
}

.container {
    max-width: 500px;
    width: 100%;
    background: #ffffff;
    padding: 40px;
    border-radius: 12px;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
}

h2 {
    color: #1a202c;
    font-size: 26px;
    font-weight: 700;
    margin-bottom: 25px;
    text-align: center;
    border-bottom: 2px solid #e2e8f0;
    padding-bottom: 15px;
}

.form-group {
    margin-bottom: 20px;
}

label {
    display: block;
    margin-bottom: 8px;
    color: #4a5568;
    font-weight: 600;
    font-size: 14px;
}

input:not([type="file"]), select {
    width: 100%;
    padding: 12px;
    border: 1px solid #cbd5e0;
    border-radius: 8px;
    transition: border-color 0.3s, box-shadow 0.3s;
    font-size: 16px;
    -webkit-appearance: none;
    -moz-appearance: none;
    appearance: none;
}

input:focus, select:focus {
    border-color: #007bff;
    box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.2);
    outline: none;
}

input[type="file"] {
    padding: 10px;
    border: 1px dashed #cbd5e0;
    border-radius: 8px;
    width: 100%;
    background: #f7fafc;
}

.input-row {
    display: flex;
    gap: 15px;
}
.input-row > * {
    flex: 1;
}

button[type="submit"] {
    width: 100%;
    padding: 14px;
    background: #007bff;
    color: white;
    border: none;
    border-radius: 8px;
    font-size: 18px;
    font-weight: 600;
    cursor: pointer;
    transition: background-color 0.3s, transform 0.1s;
    margin-top: 10px;
}

button[type="submit"]:hover {
    background: #0056b3;
}

button[type="submit"]:active {
    transform: scale(0.99);
}

.message {
    padding: 15px;
    margin-bottom: 20px;
    border-radius: 8px;
    font-weight: 600;
    text-align: center;
}
.success {
    background: #e6ffed;
    color: #2f855a;
    border: 1px solid #9ae6b4;
}
.error {
    background: #fff5f5;
    color: #c53030;
    border: 1px solid #feb2b2;
}
</style>
</head>

<body>

<div class="container">
    <h2>👤 User Account Creation</h2>

    <?php if ($message != ""): ?>
        <div class="message <?php echo $message_class; ?>">
            <?php echo ($message_class == 'success' ? '✅ ' : '❌ ') . $message; ?>
        </div>
    <?php endif; ?>

    <form method="POST" enctype="multipart/form-data">

        <div class="form-group">
            <label for="type">Select User Role</label>
            <select name="type" id="type" required>
                <option value="" disabled selected>-- Choose Role --</option>
                <option value="client_head" <?php if(isset($_POST['type']) && $_POST['type'] == 'client_head') echo 'selected'; ?>>Client Head (Multiple Schools)</option>
                <option value="principal" <?php if(isset($_POST['type']) && $_POST['type'] == 'principal') echo 'selected'; ?>>Principal (Single School)</option>
            </select>
        </div>

        <div class="input-row">
            <div class="form-group">
                <label for="first_name">First Name <span style="color: red;">*</span></label>
                <input type="text" name="first_name" id="first_name" placeholder="John" required value="<?php echo htmlspecialchars($_POST['first_name'] ?? ''); ?>">
            </div>
            <div class="form-group">
                <label for="last_name">Last Name</label>
                <input type="text" name="last_name" id="last_name" placeholder="Doe" value="<?php echo htmlspecialchars($_POST['last_name'] ?? ''); ?>">
            </div>
        </div>

        <div class="form-group">
            <label for="username">Username <span style="color: red;">*</span></label>
            <input type="text" name="username" id="username" placeholder="Unique System Username" required value="<?php echo htmlspecialchars($_POST['username'] ?? ''); ?>">
        </div>

        <div class="form-group">
            <label for="password">Password <span style="color: red;">*</span></label>
            <input type="password" name="password" id="password" placeholder="System Password" required>
        </div>

        <div class="form-group">
            <label for="email">Email Address (Optional)</label>
            <input type="email" name="email" id="email" placeholder="user@example.com" value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>">
        </div>

        <div class="form-group">
            <label for="phone">Phone Number</label>
            <input type="text" name="phone" id="phone" placeholder="+123-456-7890" value="<?php echo htmlspecialchars($_POST['phone'] ?? ''); ?>">
        </div>
        
        <div class="form-group">
            <label for="photo">Profile Photo (Optional)</label>
            <input type="file" name="photo" id="photo" accept="image/*">
        </div>

        <div class="form-group">
            <label for="partnered_on">Partnered On Date</label>
            <input type="date" name="partnered_on" id="partnered_on" value="<?php echo htmlspecialchars($_POST['partnered_on'] ?? date('Y-m-d')); ?>">
        </div>

        <button type="submit" name="submit">🚀 Create User Account</button>
    </form>
</div>

</body>
</html>