<?php
session_start();

// ======================================================
// 1. DATABASE CONNECTION (DIRECT – NO db.php)
// ======================================================
$host = "localhost";
$user = "thevkin_schlautdb";
$pass = "VK_AutSchlDb";
$db   = "thevkin_schlautdb";

$conn = mysqli_connect($host, $user, $pass, $db);

if(!$conn){
    die("Database Connection Failed!");
}

// ======================================================
// 2. USER MUST LOGIN
// ======================================================
if(!isset($_SESSION['superadmin_id'])){
    header("Location: login.php");
    exit();
}

$admin_id = $_SESSION['superadmin_id'];

// ======================================================
// 3. FETCH USER DETAILS
// ======================================================
$q = mysqli_query($conn, "SELECT * FROM superadmin_login WHERE id='$admin_id'");
$user = mysqli_fetch_assoc($q);

$logged_name  = $user['name'];
$logged_photo = $user['photo'];

if(!$logged_photo || $logged_photo == ""){
    $logged_photo = "user.png";  // default
}
?>

<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Super Admin Dashboard</title>

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

<style>
/* ---------- MAIN LAYOUT ---------- */
body {
    margin: 0;
    padding: 0;
    font-family: "Poppins", sans-serif;
    display: flex;
    height: 100vh;
    background: #f4f6fb;
}

/* LEFT PANEL */
.left-panel {
    width: 17%;
    background: linear-gradient(180deg, #0a2a43, #075985, #0c4a6e);
    display: flex;
    flex-direction: column;
    color: white;
    box-shadow: 5px 0 10px rgba(0,0,0,0.2);
}

/* LOGO */
.left-top {
    height: 90px;
    display: flex;
    align-items: center;
    padding-left: 15px;
    border-bottom: 1px solid rgba(255,255,255,0.2);
}

.left-top img {
    width: 75px;
    border-radius: 10px;
}

/* MENU */
.left-bottom {
    padding: 12px;
}

h3 {
    margin-bottom: 12px;
    color: #fff;
    font-size: 16px;
}

ul { list-style: none; padding: 0; }
li {
    margin: 8px 0;
    padding: 8px 12px;
    background-color: rgba(255,255,255,0.1);
    border-radius: 7px;
    transition: 0.3s;
}
li:hover { background: rgba(255,255,255,0.25); transform: translateX(5px); }
li a {
    color: white;
    text-decoration: none;
    font-size: 14px;
}

/* RIGHT PANEL */
.right-panel {
    width: 83%;
    display: flex;
    flex-direction: column;
}

/* TOP PROFILE BAR */
.right-top {
    height: 70px;
    background: white;
    border-bottom: 1px solid #ddd;
    display: flex;
    justify-content: flex-end;
    align-items: center;
    padding-right: 25px;
}

/* PROFILE BOX */
.profile-box {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 8px 15px;
    border-radius: 30px;
    background: #e6f2ff;
    cursor: pointer;
}

.profile-box img {
    width: 43px;
    height: 43px;
    border-radius: 50%;
    object-fit: cover;
    border: 2px solid #1d4ed8;
}

.profile-box span {
    font-size: 16px;
    font-weight: 600;
    color: #1e3a8a;
}

/* LOGOUT */
.logout-btn {
    margin-left: 12px;
    font-size: 13px;
    color: red;
    font-weight: bold;
    text-decoration: none;
}
.logout-btn:hover { text-decoration: underline; }

/* CONTENT FRAME */
.right-bottom { flex-grow: 1; background: white; }
iframe { width: 100%; height: 100%; border: none; }
</style>

<script>
function openProfile(){
    document.querySelector("iframe[name='main_frame']").src = "profile.php";
}
</script>

</head>
<body>

<!-- LEFT PANEL -->
<div class="left-panel">

    <div class="left-top">
        <img src="https://thevk.in/wp-content/uploads/2025/04/vk-brand-logo.jpg">
    </div>

    <div class="left-bottom">
        <h3>MENU</h3>
        <ul>
            <li><a href="dashboard_main.php" target="main_frame">Dashboard</a></li>
            <li><a href="add_user.php" target="main_frame">Create users</a></li>
        </ul>
    </div>

</div>

<!-- RIGHT PANEL -->
<div class="right-panel">

    <div class="right-top">
        <div class="profile-box" onclick="openProfile()">
            <img src="<?php echo $logged_photo; ?>">
            <span><?php echo $logged_name; ?></span>
        </div>

        <a class="logout-btn" href="logout.php">Logout</a>
    </div>

    <div class="right-bottom">
        <iframe name="main_frame"></iframe>
    </div>

</div>

</body>
</html>
